#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandelbrot potential coloringMod01.fsh by  matistjati
//https://www.shadertoy.com/view/WlBGDc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


#define mouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const vec2 origin = vec2(-.01,.74);
const float escapeRadius = 1000000.;

vec3 getColor(float v)
{
    /*vec3 col = vec3(0.1) * sin(v);
    col = mix(col, vec3(0.1, 0.2, 0.4), sin(1.-v));
    col = mix(col, vec3(0.1, 0.2, 0.7), pow(sin(1.-v),2.));
    return col;*/
	
    float a = 1.;
    float b = 0.34004648219;  // 1/3*sqrt(2)
    float c = 0.17965377284; // 1/7*3^(1/8)
    return vec3((1.-cos(a*v))*0.5, (1.-cos(b*v))*0.5, (1.-cos(c*v))*0.5);
}

vec3 iterate(vec2 c)
{
    float m = dot(c,c);
    vec2 z = c;
    vec2 dz = vec2(0.0);
    vec3 col = vec3(1.);

    
    //const float k = 0.69314718056;
    const float maxIter = 1000.;
    float i=0.;
    float power = 1.;
    for(;i<maxIter;i++)
    {
        dz = 2.* mat2(z,-z.y,z.x) * dz + 1.;
        
        power = power * 2.;
        z = mat2(z, -z.y, z.x) * z + c;
        
        m = dot(z,z);
        if(m>escapeRadius)
        {
            float dist = sqrt( m/dot(dz, dz))*0.5f*log(m);
			
            float k;
            k = abs(sin(iTime*0.3))*3.;
            // Try uncommenting these individually
            k = (1./sqrt(sqrt(sqrt(sqrt(dist)))))* (k*k+.25);
            //k *= 100.;
            //k = k + (1.-(1./(sqrt(sqrt(sqrt(dist))))));
                
            
        	float v = log(log(m)/power)/k;
            col = getColor(v);
            break;
        }
        
    }
    
    return col;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float t = 2157.7;
    float tz = 0.5-0.5*cos(0.225*t);
    float zoom = pow( 0.5, 13.0*tz );
    
	vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy ) / iResolution.y;
    
    vec2 c = origin + uv*zoom;
    
    vec3 col = iterate(c);

    gl_FragColor = vec4(col,1.0);
}